/*
 * Decompiled with CFR 0.152.
 */
package org.cloudwarp.mobscarecrow.entities;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5712;
import org.cloudwarp.mobscarecrow.MobScarecrow;
import org.cloudwarp.mobscarecrow.entities.MSEntityTypes;
import org.cloudwarp.mobscarecrow.registry.MSItems;
import org.cloudwarp.mobscarecrow.registry.MSParticles;
import org.cloudwarp.mobscarecrow.registry.MSSounds;
import org.cloudwarp.mobscarecrow.utils.ScarecrowAccess;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SmallPlushieEntity
extends class_1309 {
    public static final int HIDE_BASE_PLATE_FLAG = 8;
    public static final int MARKER_FLAG = 16;
    public static final class_2940<Byte> PLUSHIE_FLAGS = class_2945.method_12791(SmallPlushieEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<class_2379> TRACKER_HEAD_ROTATION = class_2945.method_12791(SmallPlushieEntity.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> TRACKER_BODY_ROTATION = class_2945.method_12791(SmallPlushieEntity.class, (class_2941)class_2943.field_13316);
    private static final class_2379 DEFAULT_HEAD_ROTATION = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_BODY_ROTATION = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_4048 MARKER_DIMENSIONS = new class_4048(0.0f, 0.0f, true);
    private static final Predicate<class_1297> RIDEABLE_MINECART_PREDICATE = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean invisible;
    public long lastHitTime;
    private class_2379 headRotation = DEFAULT_HEAD_ROTATION;
    private class_2379 bodyRotation = DEFAULT_BODY_ROTATION;
    private MSEntityTypes scarecrowType;
    protected int cooldown;
    private double distance = 16.0;

    public SmallPlushieEntity(class_1299<? extends SmallPlushieEntity> entityType, class_1937 world, MSEntityTypes scarecrowType) {
        super(entityType, world);
        this.field_6013 = 0.0f;
        this.scarecrowType = scarecrowType;
        this.distance = MobScarecrow.mobScarecrowRadius + 8.0;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PLUSHIE_FLAGS, (Object)0);
        this.field_6011.method_12784(TRACKER_HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        this.field_6011.method_12784(TRACKER_BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    private boolean canClip() {
        return !this.isMarker() && !this.method_5740();
    }

    public boolean method_6034() {
        return super.method_6034() && this.canClip();
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829(), RIDEABLE_MINECART_PREDICATE);
        for (int i = 0; i < list.size(); ++i) {
            class_1297 entity = (class_1297)list.get(i);
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isMarker() || itemStack.method_31574(class_1802.field_8448)) {
            return class_1269.field_5811;
        }
        if (player.method_7325()) {
            return class_1269.field_5812;
        }
        if (this.scarecrowType != MSEntityTypes.DEFAULT_SCARECROW) {
            this.playSqueakSound();
        }
        return class_1269.field_5811;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.field_6002.field_9236 || this.method_31481()) {
            return false;
        }
        if (class_1282.field_5849.equals(source)) {
            this.method_5768();
            return false;
        }
        if (this.method_5679(source) || this.invisible || this.isMarker()) {
            return false;
        }
        if (source.method_5535()) {
            this.onBreak(source);
            this.method_5768();
            return false;
        }
        if (class_1282.field_5867.equals(source)) {
            if (this.method_5809()) {
                this.updateHealth(source, 0.15f);
            } else {
                this.method_5639(5);
            }
            return false;
        }
        if (class_1282.field_5854.equals(source) && this.method_6032() > 0.5f) {
            this.updateHealth(source, 4.0f);
            return false;
        }
        boolean bl = source.method_5526() instanceof class_1665;
        boolean bl2 = bl && ((class_1665)source.method_5526()).method_7447() > 0;
        boolean bl3 = "player".equals(source.method_5525());
        if (!bl3 && !bl) {
            return false;
        }
        if (source.method_5529() instanceof class_1657 && !((class_1657)source.method_5529()).method_31549().field_7476) {
            return false;
        }
        if (source.method_5530()) {
            this.playBreakSound();
            this.spawnBreakParticles();
            this.method_5768();
            return bl2;
        }
        long l = this.field_6002.method_8510();
        if (l - this.lastHitTime <= 5L || bl) {
            this.breakAndDropItem(source);
            this.spawnBreakParticles();
            this.method_5768();
        } else {
            this.field_6002.method_8421((class_1297)this, (byte)32);
            this.method_32875(class_5712.field_28736, source.method_5529());
            this.lastHitTime = l;
        }
        return true;
    }

    public void method_5711(byte status) {
        if (status == 32) {
            if (this.field_6002.field_9236) {
                this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14897, this.method_5634(), 0.3f, 1.0f, false);
                this.lastHitTime = this.field_6002.method_8510();
            }
        } else {
            super.method_5711(status);
        }
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    public boolean method_5640(double distance) {
        double d;
        double d2 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < d * (d2 *= 64.0);
    }

    private void spawnBreakParticles() {
        if (this.field_6002 instanceof class_3218) {
            if (this.scarecrowType == MSEntityTypes.DEFAULT_SCARECROW) {
                ((class_3218)this.field_6002).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10359.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
                return;
            }
            ((class_3218)this.field_6002).method_14199((class_2394)MSParticles.PLUSHIE_PARTICLE, this.method_23317(), this.method_23323(0.66666), this.method_23321(), 10, (double)(this.method_17681() / 8.0f), (double)(this.method_17682() / 8.0f), (double)(this.method_17681() / 8.0f), 0.2);
        }
    }

    private void updateHealth(class_1282 damageSource, float amount) {
        float f;
        float f2 = this.method_6032();
        f2 -= amount;
        if (f <= 0.5f) {
            this.onBreak(damageSource);
            this.method_5768();
        } else {
            this.method_6033(f2);
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
        }
    }

    private void breakAndDropItem(class_1282 damageSource) {
        class_2248.method_9577((class_1937)this.field_6002, (class_2338)this.method_24515(), (class_1799)new class_1799((class_1935)MSItems.get(this.scarecrowType.id)));
        this.onBreak(damageSource);
    }

    private void onBreak(class_1282 damageSource) {
        this.playBreakSound();
        this.method_16080(damageSource);
    }

    private void playBreakSound() {
        if (this.scarecrowType == MSEntityTypes.DEFAULT_SCARECROW) {
            this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15037, this.method_5634(), 1.0f, 1.0f);
            return;
        }
        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), MSSounds.PLUSHIE_BREAK_EVENT, this.method_5634(), 1.0f, 1.0f);
    }

    private void playSqueakSound() {
        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), MSSounds.PLUSHIE_SQUEAK_EVENT, this.method_5634(), 1.0f, 1.0f);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    protected float method_6031(float bodyRotation, float headRotation) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    public void method_6091(class_243 movementInput) {
        if (!this.canClip()) {
            return;
        }
        super.method_6091(movementInput);
    }

    public void method_5636(float bodyYaw) {
        this.field_6220 = this.field_5982 = bodyYaw;
        this.field_6259 = this.field_6241 = bodyYaw;
    }

    public class_1306 method_6068() {
        return null;
    }

    public void method_5847(float headYaw) {
        this.field_6220 = this.field_5982 = headYaw;
        this.field_6259 = this.field_6241 = headYaw;
    }

    protected void method_6027() {
        this.method_5648(this.invisible);
    }

    public void method_5648(boolean invisible) {
        this.invisible = invisible;
        super.method_5648(invisible);
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean method_5659() {
        return this.method_5767();
    }

    public class_3619 method_5657() {
        if (this.isMarker()) {
            return class_3619.field_15975;
        }
        return super.method_5657();
    }

    private void setMarker(boolean marker) {
        this.field_6011.method_12778(PLUSHIE_FLAGS, (Object)this.setBitField((Byte)this.field_6011.method_12789(PLUSHIE_FLAGS), 16, marker));
    }

    public boolean isMarker() {
        return ((Byte)this.field_6011.method_12789(PLUSHIE_FLAGS) & 0x10) != 0;
    }

    private byte setBitField(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void setHeadRotation(class_2379 angle) {
        this.headRotation = angle;
        this.field_6011.method_12778(TRACKER_HEAD_ROTATION, (Object)angle);
    }

    public void setBodyRotation(class_2379 angle) {
        this.bodyRotation = angle;
        this.field_6011.method_12778(TRACKER_BODY_ROTATION, (Object)angle);
    }

    public class_2379 getHeadRotation() {
        return this.headRotation;
    }

    public class_2379 getBodyRotation() {
        return this.bodyRotation;
    }

    public boolean method_5863() {
        return super.method_5863() && !this.isMarker();
    }

    public boolean method_5698(class_1297 attacker) {
        return attacker instanceof class_1657 && !this.field_6002.method_8505((class_1657)attacker, this.method_24515());
    }

    public class_1309.class_6823 method_39760() {
        if (this.scarecrowType == MSEntityTypes.DEFAULT_SCARECROW) {
            return new class_1309.class_6823(class_3417.field_14965, class_3417.field_14965);
        }
        return new class_1309.class_6823(MSSounds.PLUSHIE_BREAK_EVENT, MSSounds.PLUSHIE_BREAK_EVENT);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        if (this.scarecrowType == MSEntityTypes.DEFAULT_SCARECROW) {
            return class_3417.field_14720;
        }
        return MSSounds.PLUSHIE_BREAK_EVENT;
    }

    @Nullable
    protected class_3414 method_6002() {
        if (this.scarecrowType == MSEntityTypes.DEFAULT_SCARECROW) {
            return class_3417.field_15037;
        }
        return MSSounds.PLUSHIE_BREAK_EVENT;
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public void method_5674(class_2940<?> data) {
        if (PLUSHIE_FLAGS.equals(data)) {
            this.method_18382();
            this.field_23807 = !this.isMarker();
        }
        super.method_5674(data);
    }

    public boolean method_6102() {
        return false;
    }

    private void setHideBasePlate(boolean hideBasePlate) {
        this.field_6011.method_12778(PLUSHIE_FLAGS, (Object)this.setBitField((Byte)this.field_6011.method_12789(PLUSHIE_FLAGS), 8, hideBasePlate));
    }

    public boolean shouldHideBasePlate() {
        return ((Byte)this.field_6011.method_12789(PLUSHIE_FLAGS) & 8) != 0;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.getDimensions(this.isMarker());
    }

    private class_4048 getDimensions(boolean marker) {
        if (marker) {
            // empty if block
        }
        return this.method_5864().method_18386();
    }

    public class_243 method_31166(float tickDelta) {
        if (this.isMarker()) {
            class_238 box = this.getDimensions(false).method_30757(this.method_19538());
            class_2338 blockPos = this.method_24515();
            int i = Integer.MIN_VALUE;
            for (class_2338 blockPos2 : class_2338.method_10097((class_2338)new class_2338(box.field_1323, box.field_1322, box.field_1321), (class_2338)new class_2338(box.field_1320, box.field_1325, box.field_1324))) {
                int j = Math.max(this.field_6002.method_8314(class_1944.field_9282, blockPos2), this.field_6002.method_8314(class_1944.field_9284, blockPos2));
                if (j == 15) {
                    return class_243.method_24953((class_2382)blockPos2);
                }
                if (j <= i) continue;
                i = j;
                blockPos = blockPos2.method_10062();
            }
            return class_243.method_24953((class_2382)blockPos);
        }
        return super.method_31166(tickDelta);
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)MSItems.get(this.scarecrowType.id));
    }

    public boolean method_36608() {
        return !this.method_5767() && !this.isMarker();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Invisible", this.method_5767());
        nbt.method_10556("NoBasePlate", this.shouldHideBasePlate());
        if (this.isMarker()) {
            nbt.method_10556("Marker", this.isMarker());
        }
        nbt.method_10566("Pose", (class_2520)this.poseToNbt());
    }

    public void method_5749(class_2487 nbt) {
        this.method_5648(nbt.method_10577("Invisible"));
        this.setHideBasePlate(nbt.method_10577("NoBasePlate"));
        this.setMarker(nbt.method_10577("Marker"));
        this.field_5960 = !this.canClip();
        class_2487 nbtCompound = nbt.method_10562("Pose");
        this.readPoseNbt(nbtCompound);
    }

    private void readPoseNbt(class_2487 nbt) {
        class_2499 nbtList = nbt.method_10554("Head", 5);
        this.setHeadRotation(nbtList.isEmpty() ? DEFAULT_HEAD_ROTATION : new class_2379(nbtList));
        class_2499 nbtList2 = nbt.method_10554("Body", 5);
        this.setBodyRotation(nbtList2.isEmpty() ? DEFAULT_BODY_ROTATION : new class_2379(nbtList2));
    }

    private class_2487 poseToNbt() {
        class_2487 nbtCompound = new class_2487();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            nbtCompound.method_10566("Head", (class_2520)this.headRotation.method_10255());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            nbtCompound.method_10566("Body", (class_2520)this.bodyRotation.method_10255());
        }
        return nbtCompound;
    }

    public void method_5773() {
        class_2379 eulerAngle2;
        super.method_5773();
        class_2379 eulerAngle = (class_2379)this.field_6011.method_12789(TRACKER_HEAD_ROTATION);
        if (!this.headRotation.equals((Object)eulerAngle)) {
            this.setHeadRotation(eulerAngle);
        }
        if (!this.bodyRotation.equals((Object)(eulerAngle2 = (class_2379)this.field_6011.method_12789(TRACKER_BODY_ROTATION)))) {
            this.setBodyRotation(eulerAngle2);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = class_3532.method_38788((int)10, (int)2);
        this.scarecrowType.getScaredEntities().forEach((Consumer<Class<? extends class_1309>>)((Consumer<Class>)entity -> {
            List targets = this.field_6002.method_8390(entity, this.method_5829().method_1009(this.distance, 3.0, this.distance), living -> true);
            targets.forEach(livingEntity -> ((ScarecrowAccess)livingEntity).addScarecrow(this, ((ScarecrowAccess)livingEntity).getScaryScarecrows()));
        }));
        this.scarecrowType.getAttractedEntities().forEach((Consumer<Class<? extends class_1309>>)((Consumer<Class>)entity -> {
            List targets = this.field_6002.method_8390(entity, this.method_5829().method_1009(this.distance, 3.0, this.distance), living -> true);
            targets.forEach(livingEntity -> ((ScarecrowAccess)livingEntity).addScarecrow(this, ((ScarecrowAccess)livingEntity).getAttractiveScarecrows()));
        }));
    }
}

